<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit();
}

// Increase memory limit and set execution time
ini_set('memory_limit', '512M');
set_time_limit(300); // 5 minutes

require_once('includes/config.php');
require_once('vendor/autoload.php');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Cell\Coordinate;

if (!isset($_GET['client_id'])) {
    die('Client ID is required');
}

$client_id = intval($_GET['client_id']);

try {
    // Get client name for the filename
    $stmt = $db1->prepare("SELECT CompanyName FROM tbl_clients WHERE Id = ?");
    $stmt->execute([$client_id]);
    $company = $stmt->fetch(PDO::FETCH_ASSOC);
    $companyName = preg_replace('/[^A-Za-z0-9]/', '_', $company['CompanyName']);

    // Create new spreadsheet with minimal memory usage
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    
    // Set headers
    $headers = ['Passport ID', 'Passport Number', 'Nationality', 'Timestamp'];
    foreach ($headers as $key => $header) {
        $sheet->setCellValue(chr(65 + $key) . '1', $header);
    }

    // Style headers
    $sheet->getStyle('A1:D1')->getFont()->setBold(true);
    $sheet->getStyle('A1:D1')->getFill()
          ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
          ->getStartColor()->setARGB('FFCCCCCC');

    // Process data in chunks
    $chunkSize = 1000;
    $row = 2;
    
    $stmt = $db1->prepare("SELECT passport_id, ppno, nationality, timestamp 
                          FROM passports_1446_2024 
                          WHERE client_id = ? 
                          ORDER BY timestamp DESC");
    $stmt->execute([$client_id]);
    
    while ($passport = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $sheet->setCellValue('A' . $row, $passport['passport_id']);
        $sheet->setCellValue('B' . $row, $passport['ppno']);
        $sheet->setCellValue('C' . $row, $passport['nationality']);
        $sheet->setCellValue('D' . $row, $passport['timestamp']);
        
        $row++;
        
        // Free memory periodically
        if ($row % $chunkSize === 0) {
            $sheet->garbageCollect();
        }
    }

    // Auto-size columns
    foreach (range('A', 'D') as $col) {
        $sheet->getColumnDimension($col)->setAutoSize(true);
    }

    // Prepare the file for download
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="' . $companyName . '_passports_' . date('Y-m-d') . '.xlsx"');
    header('Cache-Control: max-age=0');

    // Use lower memory writer
    $writer = new Xlsx($spreadsheet);
    $writer->setPreCalculateFormulas(false);
    
    // Write to php://output
    $writer->save('php://output');
    
    // Clean up
    $spreadsheet->disconnectWorksheets();
    unset($spreadsheet);
    exit;

} catch (Exception $e) {
    error_log("Export error: " . $e->getMessage());
    die('An error occurred while exporting the data.');
} 