<?php
// Include necessary files and functions
include_once("includes/config.php");
include_once("functions.php");

// Set variables
$Page = "edit_client";
//$Form_Process = "your_form_process.php"; // Ensure this is set properly
//$ID = 1; // Make sure to set this dynamically if needed

// Get necessary data
$result = get_available_clients_variables();
$apps_result = get_avaiable_clients_apps_variables();
$USERS = clients_variables();

// Display success or error messages
Message("edited_successfully", "success", "success_icon.png", "Client Successfully Edited");
Message("Failed_User_Exist", "failed", "error_icon.png", "Error! User Name Already Exists.");
?>
<div class="container">
    <div class="formLayout">
        <?php
        // Display messages
        Message("edited_successfully", "success", "success_icon.png", "Client Successfully Edited");
        Message("Failed_User_Exist", "danger", "error_icon.png", "Error! User Name Already Exists.");
        ?>

        <div class="page-header">
            <h3>Edit Client</h3>
        </div>

        <form action="<?php echo SITE_URL . '/form_process.php?page=edit_client&id=' . $ID; ?>" method="post">
            <div class="row">
                <!-- Basic Information -->
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="safa_ea_id" class="form-label">Virgo ID</label>
                        <input type="text" class="form-control" name="safa_ea_id" id="safa_ea_id" 
                               value="<?php echo $result['safa_ea_id']; ?>">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="Company_name" class="form-label">Company Name</label>
                        <input type="text" class="form-control" name="Company_name" id="Company_name" 
                               value="<?php echo $result['CompanyName']; ?>">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="Person_Incharge" class="form-label">Person Incharge</label>
                        <input type="text" class="form-control" name="Person_Incharge" id="Person_Incharge" 
                               value="<?php echo $result['PersonIncharge']; ?>">
                    </div>
                </div>

                <!-- Contact Information -->
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="Country" class="form-label">Country</label>
                        <select name="Country" id="Country" class="form-select">
                            <?php Edit_Countries(); ?>
                        </select>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="City" class="form-label">City</label>
                        <input type="text" class="form-control" name="City" value="<?php echo $result['City']; ?>">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="Telephone" class="form-label">Telephone</label>
                        <input type="text" class="form-control" name="Telephone" value="<?php echo $result['Telephone']; ?>">
                    </div>
                </div>

                <!-- Additional Information -->
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="Email" class="form-label">Email</label>
                        <input type="email" class="form-control" name="Email" value="<?php echo $result['Email']; ?>">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="Connection" class="form-label">Connection</label>
                        <input type="text" class="form-control" name="Connection" id="Connection" 
                               value="<?php echo $result['connection_id']; ?>">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="MSN" class="form-label">MSN</label>
                        <input type="text" class="form-control" name="MSN" value="<?php echo $result['MSN']; ?>">
                    </div>
                </div>

                <!-- Dates and Balance -->
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="Purchase_Date" class="form-label">Purchase Date</label>
                        <input type="date" class="form-control" name="Purchase_Date" 
                               value="<?php echo date('Y-m-d', strtotime($result['Purchase_Date'])); ?>">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="Renew_Date" class="form-label">Renew Date</label>
                        <input type="date" class="form-control" name="Renew_Date" 
                               value="<?php echo date('Y-m-d', strtotime($result['Renew_Date'])); ?>">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="Start_Balance" class="form-label">Start Balance</label>
                        <input type="text" class="form-control" name="Start_Balance" maxlength="8" 
                               value="<?php echo $result['Start_Balance']; ?>">
                    </div>
                </div>

                <!-- License Information -->
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="max_license" class="form-label">Max License</label>
                        <input type="text" class="form-control" name="max_license" maxlength="3" 
                               value="<?php echo $result['max_license']; ?>">
                    </div>
                </div>
            </div>

            <!-- Checkboxes -->
            <div class="row mt-4">
                <div class="col-md-3">
                    <div class="form-check">
                        <input type="checkbox" class="form-check-input" name="free_license" id="free_license" value="1" 
                               <?php if($result['free_license'] == 1) echo "checked='checked'"; ?>>
                        <label for="free_license" class="form-check-label">Free License</label>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="barcode" value="1" 
                               <?php if($result['Barcode_Enabled'] == 1) echo "checked='checked'"; ?>>
                        <label class="form-check-label" for="barcode">Barcode</label>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="alert_enabled" id="alert_enabled" value="1" 
                               <?php if($result['alert_enabled'] == 1) echo "checked='checked'"; ?>>
                        <label class="form-check-label" for="alert_enabled">Credit Alert</label>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="license_enabled" id="license_enabled" value="1" 
                               <?php if($result['license_enabled'] == 1) echo "checked='checked'"; ?>>
                        <label class="form-check-label" for="license_enabled">License Enabled</label>
                    </div>
                </div>
            </div>

            <!-- Message -->
            <div class="form-group mt-4">
                <label for="Message" class="form-label">Message</label>
                <textarea name="Message" class="form-control" rows="3"><?php echo $result['Message']; ?></textarea>
            </div>

            <!-- License Code -->
            <div class="form-group mt-4">
                <label class="form-label">License Code</label>
                <div class="license-code">
                    <?php 
                    if($result['license'] == '') { 
                        echo '<a href="https://auth.virgo-sy.com/v6/getlicense.php?id=' . $ID . '" 
                              target="_blank" class="btn btn-primary">Get License</a>';
                    } else {
                        echo '<span class="license-text">' . $result['license'] . '</span>';
                    } 
                    ?>
                </div>
            </div>

            <!-- Credit Information -->
            <div class="formLayout mt-4">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h3>Credit Information</h3>
                    <button type="button" class="btn btn-primary" onclick="loadCredit(<?php echo $ID; ?>)">
                        <i class="bi bi-arrow-clockwise"></i> Load Credit
                    </button>
                </div>
                <div id="creditInfo"></div>
            </div>

            <!-- Applications Table -->
            <div class="table-responsive mt-4">
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">Applications</h5>
                    </div>
                    <div class="card-body p-0">
                        <table class="table table-hover mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th class="border-bottom text-center" style="width: 80px;">
                                        <i class="bi bi-check-circle" title="Available"></i>
                                    </th>
                                    <th class="border-bottom text-center" style="width: 80px;">
                                        <i class="bi bi-slash-circle" title="Blocked"></i>
                                    </th>
                                    <th class="border-bottom">Application</th>
                                    <th class="border-bottom">Version</th>
                                    <th class="border-bottom">User</th>
                                    <th class="border-bottom">Serial</th>
                                    <th class="border-bottom">Last Counter</th>
                                    <th class="border-bottom">Package Limit</th>
                                    <th class="border-bottom">Last Access</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                if ($apps_result) {
                                    foreach ($apps_result['App_Id'] as $index => $app_id) {
                                        $app = $apps_result['Application_Name'][$index];
                                        echo "<tr>";
                                        // Available checkbox
                                        echo '<td class="text-center align-middle">
                                            <div class="form-check d-flex justify-content-center">
                                                <input class="form-check-input" name="Available_' . $app . '" type="checkbox" 
                                                       value="1"' . ($apps_result['availability'][$index] == 1 ? " checked" : "") . '>
                                            </div>
                                        </td>';
                                        // Blocked checkbox
                                        echo '<td class="text-center align-middle">
                                            <div class="form-check d-flex justify-content-center">
                                                <input class="form-check-input" name="Block_' . $app . '" type="checkbox" 
                                                       value="1"' . ($apps_result['Blocked'][$index] == 1 ? " checked" : "") . '>
                                            </div>
                                        </td>';
                                        echo '<td class="align-middle">' . $app . '</td>';
                                        echo '<td class="align-middle">' . $apps_result['Version'][$index] . '</td>';
                                        echo '<td class="align-middle">' . $apps_result['User'][$index] . '</td>';
                                        echo '<td class="align-middle">
                                            <span class="text-monospace">' . $apps_result['serial'][$index] . '</span>
                                        </td>';
                                        echo '<td class="align-middle text-end">' . number_format($apps_result['Last_Counter'][$index]) . '</td>';
                                        echo '<td class="align-middle">
                                            <div class="input-group input-group-sm">
                                                <input type="text" class="form-control" name="' . $app . '_Limit" 
                                                       value="' . $apps_result['Stop_At'][$index] . '" maxlength="6">
                                                <button class="btn btn-primary" type="submit" name="submit">
                                                    <i class="bi bi-check-lg"></i>
                                                </button>
                                            </div>
                                        </td>';
                                        echo '<td class="align-middle small text-muted">' . $apps_result['Time_stamp'][$index] . '</td>';
                                        echo "</tr>";
                                    }
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- MAC Addresses -->
            <div class="formLayout mt-4">
                <h3>MAC Addresses</h3>
                <div class="row">
                    <?php get_list_mac(); ?>
                </div>
            </div>

            <!-- Submit Button -->
            <div class="form-actions mt-4">
                <button type="submit" class="btn btn-primary">Save Changes</button>
            </div>
        </form>
    </div>
</div>

<script>
const SITE_URL = '<?php echo SITE_URL; ?>';

// Add DOMContentLoaded event listener to load credit automatically
document.addEventListener('DOMContentLoaded', function() {
    loadCredit(<?php echo $ID; ?>);
});

function loadCredit(clientId) {
    const creditInfo = document.getElementById('creditInfo');
    creditInfo.innerHTML = '<div class="spinner-border text-primary" role="status"><span class="visually-hidden">Loading...</span></div>';
    
    const visaTypes = {
        'VOU': 'Umrah',
        'VOH': 'Hajj',
        'VOT': 'Tourism',
        'VOW': 'Work',
        'VOE': 'Enjaz'
    };

    fetch(SITE_URL + '/ajax/get_credit.php?client_id=' + clientId)
        .then(response => response.json())
        .then(data => {
            let html = `
                <div class="row g-4">
                    <!-- Credit Counters Card -->
                    <div class="col-12">
                        <div class="card border-0 shadow-sm">
                            <div class="card-header bg-white">
                                <h5 class="mb-0">Credit Counters (1446)</h5>
                            </div>
                            <div class="card-body">
                                <div class="row g-4">
                                    <!-- Visa Counters -->
                                    <div class="col-md-6">
                                        <h6>Visa Counters</h6>
                                        <div class="list-group">
                                            ${data.printed_visa_counter > 0 ? `
                                                <div class="list-group-item d-flex justify-content-between align-items-center">
                                                    <span>Printed Visa Counter</span>
                                                    <span class="badge bg-primary rounded-pill">${data.printed_visa_counter}</span>
                                                </div>
                                            ` : ''}
                                            ${Object.entries(data.current_year)
                                                .filter(([_, count]) => count > 0)
                                                .map(([type, count]) => `
                                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                                        <span>${visaTypes[type] || type}</span>
                                                        <span class="badge bg-primary rounded-pill">${count}</span>
                                                    </div>
                                                `).join('')}
                                            ${data.yesterday_count > 0 ? `
                                                <div class="list-group-item d-flex justify-content-between align-items-center">
                                                    <span>Yesterday's Count</span>
                                                    <span class="badge bg-primary rounded-pill">${data.yesterday_count}</span>
                                                </div>
                                            ` : ''}
                                        </div>
                                    </div>

                                    <!-- Passport Counters -->
                                    <div class="col-md-6">
                                        <h6>Passport Counters</h6>
                                        <div class="list-group">
                                            ${Object.entries(data.passport_counts)
                                                .filter(([_, count]) => count > 0)
                                                .map(([type, count]) => `
                                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                                        <span>${visaTypes[type] || type}</span>
                                                        <span class="badge bg-primary rounded-pill">${count}</span>
                                                    </div>
                                                `).join('')}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Historical Data Cards -->
                    <div class="col-12">
                        <div class="row g-4">
                            ${Object.entries(data.historical)
                                .map(([year, yearData]) => {
                                    const hasData = Object.values(yearData.passports)
                                        .some(stats => stats.unique > 0 || stats.total > 0);
                                    if (!hasData) return '';
                                    
                                    return `
                                        <div class="col-md-6 col-xl-4">
                                            <div class="card border-0 shadow-sm h-100">
                                                <div class="card-header bg-white">
                                                    <h6 class="mb-0">Year ${year}</h6>
                                                </div>
                                                <div class="card-body p-0">
                                                    <div class="list-group list-group-flush">
                                                        ${Object.entries(yearData.passports)
                                                            .filter(([_, stats]) => stats.unique > 0 || stats.total > 0)
                                                            .map(([type, stats]) => `
                                                                <div class="list-group-item">
                                                                    <div class="d-flex justify-content-between align-items-center mb-2">
                                                                        <strong>${visaTypes[type] || type}</strong>
                                                                    </div>
                                                                    <div class="d-flex justify-content-between small">
                                                                        <span class="text-muted">Unique:</span>
                                                                        <span class="badge bg-secondary">${stats.unique}</span>
                                                                    </div>
                                                                    <div class="d-flex justify-content-between small">
                                                                        <span class="text-muted">Total:</span>
                                                                        <span class="badge bg-primary">${stats.total}</span>
                                                                    </div>
                                                                </div>
                                                            `).join('')}
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    `;
                                }).join('')}
                        </div>
                    </div>
                </div>
            `;
            creditInfo.innerHTML = html;
        })
        .catch(error => {
            creditInfo.innerHTML = `
                <div class="alert alert-danger d-flex align-items-center" role="alert">
                    <i class="bi bi-exclamation-triangle-fill me-2"></i>
                    <div>Error loading credit information: ${error.message}</div>
                </div>
            `;
        });
}
</script>
</body>
</html>
