<?php
require_once('../includes/config.php');

header('Content-Type: application/json');

if (!isset($_GET['client_id'])) {
    echo json_encode(['error' => 'Client ID is required']);
    exit;
}

$client_id = intval($_GET['client_id']);

try {
    $data = [];
    
    // Get hardware license visa count
    $query = "SELECT COUNT(*) AS counter FROM `authumra_visas`.`visa_number` 
             WHERE hardware_id IN (SELECT license_code FROM license WHERE client_id = :client_id)";
    $stmt = $db1->prepare($query);
    $stmt->execute(['client_id' => $client_id]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    $data['printed_visa_counter'] = $row['counter'];

    // Get current year (1447) counts by type from passports_1447_2025
    $types = ['VOU', 'VOH', 'VOE', 'VOT', 'VOW'];
    $data['current_year'] = [];
    foreach ($types as $type) {
        $query = "SELECT COUNT(*) AS counter FROM passports_1447 
                 WHERE client_id = :client_id 
                 AND type = (SELECT id FROM visa_types WHERE type = :type)";
        $stmt = $db1->prepare($query);
        $stmt->execute(['client_id' => $client_id, 'type' => $type]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        $data['current_year'][$type] = $row['counter'];
    }

    // Get yesterday's count
    $data['yesterday_count'] = [];
    foreach ($types as $type) {
        $query = "SELECT COUNT(*) AS counter FROM passports_1447_2025 
                 WHERE client_id = :client_id 
                 AND type = (SELECT id FROM visa_types WHERE type = :type) 
                 AND DATE(timestamp) = DATE_SUB(DATE(NOW()), INTERVAL 1 DAY)";
        $stmt = $db1->prepare($query);
        $stmt->execute(['client_id' => $client_id, 'type' => $type]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        $data['yesterday_count'][$type] = $row['counter'];
    }

    // Get passport counts for current year
    $data['passport_counts'] = [];
    foreach ($types as $type) {
        $query = "SELECT COUNT(*) AS counter FROM passports_1447_2025
                 WHERE client_id = :client_id 
                 AND type = (SELECT id FROM visa_types WHERE type = :type)";
        $stmt = $db1->prepare($query);
        $stmt->execute(['client_id' => $client_id, 'type' => $type]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        $data['passport_counts'][$type] = $row['counter'];
    }

    // Get historical years data
    $years = ['1445', '1444', '1443', '1442', '1441', '1440', '1439', '1438'];
    $data['historical'] = [];
    foreach ($years as $year) {
        $data['historical'][$year] = [
            'visas' => [],
            'passports' => [],
            'enjaz_passports' => []
        ];
        
        // Get visa counts from visas_$year
        foreach ($types as $type) {
            $query = "SELECT COUNT(*) AS counter FROM visas_$year 
                     WHERE client_id = :client_id 
                     AND type = (SELECT id FROM visa_types WHERE type = :type)";
            $stmt = $db1->prepare($query);
            $stmt->execute(['client_id' => $client_id, 'type' => $type]);
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            $data['historical'][$year]['visas'][$type] = $row['counter'];
        }
        
        // Get Umrah passport counts from passports_$year
        foreach ($types as $type) {
            $query = "SELECT 
                COUNT(*) AS total_count 
                FROM passports_$year 
                WHERE client_id = :client_id 
                AND type = (SELECT id FROM visa_types WHERE type = :type)";
            $stmt = $db1->prepare($query);
            $stmt->execute(['client_id' => $client_id, 'type' => $type]);
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            $data['historical'][$year]['passports'][$type] = [
                'total' => $row['total_count']
            ];
        }

        // Get Enjaz passport counts from visas_1446
        /*foreach ($types as $type) {
            $query = "SELECT 
                COUNT(*) AS total_count 
                FROM visas_1446 
                WHERE client_id = :client_id 
                AND type = 3"; // Filter for Enjaz passports
            $stmt = $db1->prepare($query);
            $stmt->execute(['client_id' => $client_id]);
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            $data['historical'][$year]['enjaz_passports'][$type] = [
                'total' => $row['total_count']
            ];
        }*/
    }

    // Get historical passport counts for years 1438 to 1445
    $old_years = ['1447', '1446', '1445', '1444', '1443', '1442', '1441', '1440', '1439', '1438'];
    $data['old_passport_counts'] = [];
    foreach ($old_years as $year) {
        // Map 1446 and 1447 to suffixed tables; others remain the same
        if ($year === '1447') {
            $table = 'passports_1447_2025';
        } elseif ($year === '1446') {
            $table = 'passports_1446_2024';
        } else {
            $table = 'passports_' . $year;
        }

        $query = "SELECT 
            COUNT(*) AS total_count 
            FROM $table 
            WHERE client_id = :client_id";
        $stmt = $db1->prepare($query);
        $stmt->execute(['client_id' => $client_id]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        $data['old_passport_counts'][$year] = [
            'total' => $row['total_count']
        ];
    }

    // Get Enjaz historical data from visas_1438 to visas_1446
    $data['enjaz_historical_data'] = [];
    $years = ['1447', '1446', '1445', '1444', '1443', '1442', '1441', '1440', '1439', '1438'];
    foreach ($years as $year) {
        $query = "SELECT 
            COUNT(*) AS total_count 
            FROM visas_$year 
            WHERE client_id = :client_id 
            AND type = 3"; // Filter for Enjaz records
        $stmt = $db1->prepare($query);
        $stmt->execute(['client_id' => $client_id]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        $data['enjaz_historical_data'][$year] = [
            'total' => $row['total_count']
        ];
    }

    echo json_encode($data);

} catch (PDOException $e) {
    error_log("Credit Info Error: " . $e->getMessage());
    echo json_encode(['error' => 'Database error occurred']);
} 
