<?php
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

header('Content-Type: application/json');
include_once("../includes/config.php");
include_once("../functions.php");

// Get the email from the request
$email = isset($_REQUEST['email']) ? trim($_REQUEST['email']) : '';

// Validate email
if (empty($email) || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
    echo json_encode([
        'success' => false,
        'message' => 'Valid email address is required'
    ]);
    exit;
}

try {
    // Get license information for this email
    $select_sql = "SELECT l.license_code, c.CompanyName 
                   FROM tbl_clients c 
                   INNER JOIN license l ON l.client_id = c.Id 
                   WHERE c.license_email = :email";
    $select_stmt = $db1->prepare($select_sql);
    $select_stmt->execute([':email' => $email]);

    if ($select_stmt->rowCount() === 0) {
        echo json_encode([
            'success' => false,
            'message' => 'No license found for this email address'
        ]);
        exit;
    }

    $row = $select_stmt->fetch(PDO::FETCH_ASSOC);
    $license_key = $row['license_code'];
    $company_name = $row['CompanyName'];

    // Prepare email content
    $subject = "Virgo Offline License Key - مفتاح ترخيص فيرجو أوفلاين";
    
    // HTML email body
    $html_message = <<<HTML
    <!DOCTYPE html>
    <html>
    <head>
        <meta charset="UTF-8">
        <style>
            body { 
                font-family: Arial, sans-serif; 
                line-height: 1.6; 
                color: #333;
                margin: 0;
                padding: 0;
            }
            .container { 
                max-width: 600px; 
                margin: 0 auto; 
                padding: 20px; 
            }
            .header { 
                text-align: center; 
                margin-bottom: 30px; 
                padding: 20px;
                background-color: #f8f9fa;
            }
            .logo { 
                max-width: 200px; 
                height: auto; 
            }
            .content { 
                background-color: #f9f9f9; 
                padding: 20px; 
                border-radius: 5px;
                margin-bottom: 20px;
            }
            .license-key { 
                background-color: #fff; 
                padding: 15px; 
                margin: 20px 0; 
                border: 2px solid #ddd; 
                border-radius: 4px; 
                font-family: monospace; 
                font-size: 16px;
                text-align: center;
                direction: ltr;
            }
            .footer { 
                text-align: center; 
                margin-top: 30px; 
                font-size: 12px; 
                color: #666;
                border-top: 1px solid #ddd;
                padding-top: 20px;
            }
            .arabic { 
                direction: rtl; 
                font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
                text-align: right;
                line-height: 1.8;
            }
            .english {
                direction: ltr;
                text-align: left;
                margin-bottom: 30px;
            }
            .divider {
                border-top: 1px solid #ddd;
                margin: 30px 0;
            }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="header">
                <img src="https://billing.virgo-sy.com/images/logo.png" alt="Virgo Offline Logo" class="logo">
            </div>

            <!-- English Content -->
            <div class="content english">
                <h2>Your Virgo Offline License Key</h2>
                <p>Dear {$company_name},</p>
                <p>Thank you for using Virgo Offline. Below is your license key:</p>
                <div class="license-key">
                    {$license_key}
                </div>
                <p>Please keep this key safe and do not share it with others. If you have any questions or need assistance, please don't hesitate to contact our support team.</p>
                <p>
                    <strong>Contact Information:</strong><br>
                    Email: support@virgo-sy.com<br>
                    Website: https://offline.umrah.software/
                </p>
            </div>

            <div class="divider"></div>

            <!-- Arabic Content -->
            <div class="content arabic">
                <h2>مفتاح ترخيص فيرجو أوفلاين</h2>
                <p>عزيزنا {$company_name}،</p>
                <p>شكراً لاستخدامك فيرجو أوفلاين. في ما يلي مفتاح الترخيص الخاص بك:</p>
                <div class="license-key">
                    {$license_key}
                </div>
                <p>يرجى الحفاظ على هذا المفتاح بأمان وعدم مشاركته مع الآخرين. إذا كان لديك أي أسئلة أو تحتاج إلى مساعدة، فلا تتردد في الاتصال بفريق الدعم لدينا.</p>
                <p>
                    <strong>معلومات الاتصال:</strong><br>
                    البريد الإلكتروني: support@virgo-sy.com<br>
                    الموقع الإلكتروني: https://offline.umrah.software/
                </p>
            </div>

            <div class="footer">
                <p>
                    This is an automated message, please do not reply to this email.<br>
                    هذه رسالة آلية، يرجى عدم الرد على هذا البريد الإلكتروني.
                </p>
                <p>© 2025 Virgo Offline. All rights reserved. | جميع الحقوق محفوظة</p>
            </div>
        </div>
    </body>
    </html>
    HTML;

    // Plain text version for email clients that don't support HTML
    $text_message = <<<TEXT
    Your Virgo Offline License Key
    ============================

    Dear {$company_name},

    Thank you for using Virgo Offline. Below is your license key:

    {$license_key}

    Please keep this key safe and do not share it with others. If you have any questions or need assistance, please don't hesitate to contact our support team.

    Contact Information:
    Email: support@virgo-sy.com
    Website: https://virgo-sy.com

    ============================

    مفتاح ترخيص فيرجو أوفلاين
    ============================

    عزيزنا {$company_name}،

    شكراً لاستخدامك فيرجو أوفلاين. في ما يلي مفتاح الترخيص الخاص بك:

    {$license_key}

    يرجى الحفاظ على هذا المفتاح بأمان وعدم مشاركته مع الآخرين. إذا كان لديك أي أسئلة أو تحتاج إلى مساعدة، فلا تتردد في الاتصال بفريق الدعم لدينا.

    معلومات الاتصال:
    البريد الإلكتروني: support@virgo-sy.com
    الموقع الإلكتروني: https://virgo-sy.com

    ============================

    This is an automated message, please do not reply to this email.
    هذه رسالة آلية، يرجى عدم الرد على هذا البريد الإلكتروني.

    © 2024 Virgo Offline. All rights reserved. | جميع الحقوق محفوظة
    TEXT;

    // Send email using SMTP
    $result = sendEmail($email, $subject, $html_message, $text_message);

    if ($result['success']) {
        echo json_encode([
            'success' => true,
            'message' => 'License key has been sent to your email address'
        ]);
    } else {
        throw new Exception($result['error'] ?? 'Unknown error occurred');
    }

} catch (Exception $e) {
    error_log("Error sending license email: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Failed to send email',
        'error' => $e->getMessage(),
        'debug_info' => isset($result) ? $result : null
    ]);
    exit;
} 