<?php
include_once("/home5/virgosy/public_html/billing/includes/config.php"); 
$debug=1;
try {

    // Find the earliest and latest date from records
    $stmt = $db1->prepare("SELECT MIN(timestamp) as min_date, MAX(timestamp) as max_date FROM passports_1447");
    $stmt->execute();
    $dateInfo = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Check if no records are returned
    if ($dateInfo === false || $dateInfo['min_date'] === null || $dateInfo['max_date'] === null) {
        echo "No records found.";
        // You can stop further execution or return from a function here
        exit;
    } else { echo "Start\n";}

    $startDate = new DateTime($dateInfo['min_date']);
    $endDate = new DateTime($dateInfo['max_date']);
    
    if ($debug) {
        echo $dateInfo['min_date']."\n\r";
        echo $dateInfo['max_date']."\n\r";
    }
    // Loop through each month
    while($startDate <= $endDate) {
        // Form the table name
        $suffix = $startDate->format('F_Y'); // September_2023
        $tableName = "passports_1447_" . $suffix;
        echo $tableName."\n\r";
        
        // Create a new table for this month
        $db1->exec("CREATE TABLE IF NOT EXISTS `$tableName` LIKE `passports_1447`");
        
        // Insert records into this new table
        $month = $startDate->format('m');
        $year = $startDate->format('Y');
        $stmt = $db1->prepare("INSERT IGNORE INTO `$tableName`
                               SELECT * FROM `passports_1447`
                               WHERE MONTH(timestamp) = :month AND YEAR(timestamp) = :year");
        $stmt->bindParam(':month', $month, PDO::PARAM_INT);
        $stmt->bindParam(':year', $year, PDO::PARAM_INT);
        $stmt->execute();
        
        // Delete these records from the original table
        $stmt = $db1->prepare("UPDATE `passports_1447` SET `archive`=1
                               WHERE MONTH(timestamp) = :month AND YEAR(timestamp) = :year");
        $stmt->bindParam(':month', $month, PDO::PARAM_INT);
        $stmt->bindParam(':year', $year, PDO::PARAM_INT);
        $stmt->execute();
        
        // Move to next month
        //$startDate->modify('+1 month');
        $startDate->modify('first day of next month');

        echo $startDate->format('Y-m-d');

    }
    
    // Now you can add code to create or update the view if needed

} catch(PDOException $e) {
    echo "Error: " . $e->getMessage();
}

$db1 = null;
?>
