<?php
require_once '../includes/config.php';
require_once '../includes/DataBaseObjects.php';

echo "Starting credit recalculation...\n";

try {
    $db = new DataBaseObjects();
    
    // Get all client applications
    $applications = $db->query("
        SELECT DISTINCT ca.client_id, ca.application_id, ca.credit_balance
        FROM tbl_clients_applications ca
        ORDER BY ca.client_id, ca.application_id
    ");
    
    $updated = 0;
    foreach ($applications as $app) {
        // Calculate active credits for this client/application
        $credits = $db->query("
            SELECT SUM(cl.credit_units) as total_credits
            FROM credits_ledger cl
            WHERE cl.client_id = ? 
              AND cl.application_id = ?
              AND cl.status = 'active'
              AND (cl.expiry_date IS NULL OR cl.expiry_date > CURDATE())
        ", [$app['client_id'], $app['application_id']]);
        
        $new_balance = $credits[0]['total_credits'] ?? 0;
        
        if ($new_balance != $app['credit_balance']) {
            $db->update('tbl_clients_applications', 
                ['client_id' => $app['client_id'], 'application_id' => $app['application_id']],
                ['credit_balance' => $new_balance]
            );
            $updated++;
            echo "Updated client {$app['client_id']} app {$app['application_id']}: {$app['credit_balance']} -> {$new_balance}\n";
        }
    }
    
    // Update cache
    $cache_data = [
        'last_run' => date('Y-m-d H:i:s'),
        'applications_processed' => count($applications),
        'applications_updated' => $updated
    ];
    file_put_contents('../cache/credit_recalculation.json', json_encode($cache_data));
    
    echo "Recalculation complete. Updated: {$updated}\n";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    exit(1);
}
?>
