<?php ob_start(); ?>
<?php @session_start(); ?>
<?php require_once("includes/config.php"); ?>
<?php require_once("includes/DataBaseObjects.php"); ?>
<?php require_once("functions.php"); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <!-- Primary Meta Tags -->
    <meta name="title" content="<?php echo SITE_NAME; ?>">
    <meta name="description" content="Client Management System - Efficiently manage and organize your client information">
    <meta name="keywords" content="client management, CRM, dashboard, client database, business management">
    <meta name="author" content="<?php echo SITE_NAME; ?>">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>">
    <meta property="og:title" content="<?php echo SITE_NAME; ?>">
    <meta property="og:description" content="Client Management System - Efficiently manage and organize your client information">
    <meta property="og:image" content="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST']; ?>/images/logo.png">
    
    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>">
    <meta property="twitter:title" content="<?php echo SITE_NAME; ?>">
    <meta property="twitter:description" content="Client Management System - Efficiently manage and organize your client information">
    <meta property="twitter:image" content="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST']; ?>/images/logo.png">

    <!-- Security Meta Tags -->
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta http-equiv="Content-Security-Policy" content="default-src 'self' https: 'unsafe-inline' 'unsafe-eval'; img-src 'self' data: https:;">
    <meta name="robots" content="noindex, nofollow"> <!-- Since this is an admin panel -->
    
    <title><?php echo SITE_NAME; ?></title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- DataTables CSS (Bootstrap 5) -->
    <link href="https://cdn.datatables.net/1.13.8/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    <!-- jQuery (load early so inline page scripts can use $) -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- DataTables JS (must load after jQuery and before inline page scripts) -->
    <script src="https://cdn.datatables.net/1.13.8/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.8/js/dataTables.bootstrap5.min.js"></script>
    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css" rel="stylesheet">    
    <style>
        :root {
            --primary-red: #dc3545;
            --dark-gray: #212529;
            --success-green: #198754;
        }
        
        body {
            background-color: #f8f9fa;
        }
        
        .navbar {
            background-color: white !important;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }

        .btn-outline-primary {
            color: var(--dark-gray);
            border-color: var(--dark-gray);
        }
        
        .btn-outline-primary:hover {
            background-color: var(--dark-gray);
            color: white;
            border-color: var(--dark-gray);
        }

        .btn-outline-success {
            color: var(--success-green);
            border-color: var(--success-green);
        }
        
        .btn-outline-success:hover {
            background-color: var(--success-green);
            color: white;
            border-color: var(--success-green);
        }

        .btn-outline-warning {
            color: var(--dark-gray);
            border-color: var(--dark-gray);
        }
        
        .btn-outline-warning:hover {
            background-color: var(--dark-gray);
            color: white;
            border-color: var(--dark-gray);
        }

        .nav-link.active {
            color: var(--primary-red) !important;
            font-weight: bold;
        }

        .navbar-text {
            color: var(--dark-gray) !important;
        }

        /* Add these mobile-specific styles */
        @media (max-width: 991.98px) {
            .navbar-brand img {
                height: 60px; /* Smaller logo on mobile */
            }
            
            .table-responsive {
                overflow-x: auto;
            }
            
            /* Stack navbar items vertically on mobile */
            .navbar-nav {
                text-align: center;
                margin: 1rem 0;
            }
            
            .navbar-nav .nav-item {
                margin: 0.5rem 0;
            }
            
            /* Adjust user info section on mobile */
            .navbar-nav:last-child {
                flex-direction: column;
                align-items: center;
            }
            
            .navbar-text {
                margin-bottom: 0.5rem;
            }
            
            /* Make buttons full width on mobile */
            .btn {
                width: 100%;
                margin: 0.25rem 0;
            }
            
            /* Add spacing between stacked elements */
            .container {
                padding: 1rem;
            }
        }
    </style>
    <script>
        function toggleVisibility(id) {
        var element = document.getElementById(id);
        if (element.style.display === "none") {
            element.style.display = "block"; // Show the element
        } else {
            element.style.display = "none";  // Hide the element
        }
    }
    </script>

</head>
<body>

<!-- Navigation Menu -->
<nav class="navbar navbar-expand-lg navbar-light bg-light sticky-top">
    <div class="container">
        <a class="navbar-brand" href="index.php">
            <img src="../images/logo.png" alt="Virgo Logo" height="100">
        </a>
        
        <!-- Updated navbar toggler with explicit icon -->
        <button class="navbar-toggler border-0" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav"
                aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <i class="bi bi-list fs-1"></i>
        </button>
        
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav w-100 justify-content-evenly">
                <li class="nav-item">
                    <a class="nav-link <?php echo !isset($_GET['page']) ? 'active' : ''; ?>" href="index.php">
                        <i class="bi bi-speedometer2"></i> Dashboard
                    </a>
                </li>
                
                <!-- Clients Section -->
                <li class="nav-item">
                    <a class="nav-link <?php echo isset($_GET['page']) && $_GET['page'] == 'add_client' ? 'active' : ''; ?>" href="?page=add_client">
                        <i class="bi bi-person-plus"></i> Add Client
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo isset($_GET['page']) && $_GET['page'] == 'edit_clients' ? 'active' : ''; ?>" href="?page=edit_clients">
                        <i class="bi bi-pencil-square"></i> Edit Clients
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo isset($_GET['page']) && $_GET['page'] == 'search_clients' ? 'active' : ''; ?>" href="?page=search_clients">
                        <i class="bi bi-search"></i> Search Clients
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo isset($_GET['page']) && $_GET['page'] == 'account_managers' ? 'active' : ''; ?>" href="?page=account_managers">
                        <i class="bi bi-people"></i> Account Managers
                    </a>
                </li>
                
                <!-- Accounting Dropdown -->
                <?php 
                    $accountingPages = ['accounts','invoices','invoice_create','payments','payment_create','currency_rates'];
                    $isAccountingActive = isset($_GET['page']) && in_array($_GET['page'], $accountingPages, true);
                ?>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle <?php echo $isAccountingActive ? 'active' : ''; ?>" href="#" id="accountingDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-calculator"></i> Accounting
                    </a>
                    <ul class="dropdown-menu" aria-labelledby="accountingDropdown">
                        <li>
                            <a class="dropdown-item <?php echo isset($_GET['page']) && $_GET['page'] == 'accounts' ? 'active' : ''; ?>" href="?page=accounts">
                                <i class="bi bi-wallet2"></i> Accounts
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item <?php echo isset($_GET['page']) && $_GET['page'] == 'payments' ? 'active' : ''; ?>" href="?page=payments">
                                <i class="bi bi-credit-card"></i> Payments
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item <?php echo isset($_GET['page']) && $_GET['page'] == 'payment_create' ? 'active' : ''; ?>" href="?page=payment_create">
                                <i class="bi bi-plus-circle"></i> Record Payment
                            </a>
                        </li>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <a class="dropdown-item <?php echo isset($_GET['page']) && $_GET['page'] == 'invoices' ? 'active' : ''; ?>" href="?page=invoices">
                                <i class="bi bi-receipt"></i> Invoices
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item <?php echo isset($_GET['page']) && $_GET['page'] == 'invoice_create' ? 'active' : ''; ?>" href="?page=invoice_create">
                                <i class="bi bi-file-earmark-plus"></i> Create Invoice
                            </a>
                        </li>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <a class="dropdown-item <?php echo isset($_GET['page']) && $_GET['page'] == 'currency_rates' ? 'active' : ''; ?>" href="?page=currency_rates">
                                <i class="bi bi-currency-exchange"></i> Currency Rates
                            </a>
                        </li>
                    </ul>
                </li>
            </ul>
            
            <!-- User Info and Logout -->
            <div class="navbar-nav">
                <span class="nav-item navbar-text me-3">
                    <i class="bi bi-person"></i> 
                    <?php echo htmlspecialchars($_SESSION['admin_username']); ?> 
                    (<?php echo htmlspecialchars($_SESSION['admin_type']); ?>)
                </span>
                <a href="logout.php" class="btn btn-outline-danger">
                    <i class="bi bi-box-arrow-right"></i> Logout
                </a>
            </div>
        </div>
    </div>
</nav>

<!-- Update the table wrapper -->
<div class="container mt-4">
    <div class="table-responsive">
        <?php include_once("content.php"); ?>
    </div>
</div>

<!-- Bootstrap JS and Popper.js -->
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.3/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<!-- Page-specific scripts -->
<?php echo $pageScripts ?? ''; ?>

<?php
// Enable error reporting for development
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Custom error handler
function customErrorHandler($errno, $errstr, $errfile, $errline) {
    $errorType = match($errno) {
        E_ERROR => 'Fatal Error',
        E_WARNING => 'Warning',
        E_PARSE => 'Parse Error',
        E_NOTICE => 'Notice',
        E_CORE_ERROR => 'Core Error',
        E_CORE_WARNING => 'Core Warning',
        E_COMPILE_ERROR => 'Compile Error',
        E_COMPILE_WARNING => 'Compile Warning',
        E_USER_ERROR => 'User Error',
        E_USER_WARNING => 'User Warning',
        E_USER_NOTICE => 'User Notice',
        default => 'Unknown Error'
    };
    
    // Only show detailed error info if it's not a notice
    if ($errno !== E_NOTICE) {
        echo "<div class='alert alert-danger' role='alert'>
                <h4 class='alert-heading'>$errorType</h4>
                <p><strong>Message:</strong> $errstr</p>
                <hr>
                <p class='mb-0'><strong>File:</strong> $errfile</p>
                <p class='mb-0'><strong>Line:</strong> $errline</p>
              </div>";
    }
    
    // Don't execute PHP internal error handler
    return true; 
}

// Set the custom error handler
set_error_handler("customErrorHandler");

// Add exception handler
function customExceptionHandler($exception) {
    echo "<div class='alert alert-danger' role='alert'>
            <h4 class='alert-heading'>Uncaught Exception</h4>
            <p><strong>Message:</strong> " . $exception->getMessage() . "</p>
            <hr>
            <p class='mb-0'><strong>File:</strong> " . $exception->getFile() . "</p>
            <p class='mb-0'><strong>Line:</strong> " . $exception->getLine() . "</p>
          </div>";
}

// Set the custom exception handler
set_exception_handler("customExceptionHandler");

// Add this to catch database errors
function handleDatabaseError($message) {
    echo "<div class='alert alert-danger' role='alert'>
            <h4 class='alert-heading'>Database Error</h4>
            <p>$message</p>
          </div>";
}

// Add some CSS for error styling
?>
<style>
    .alert-danger {
        background-color: #fff;
        border-left: 5px solid #dc3545;
        border-radius: 8px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        margin: 15px 0;
        padding: 15px 20px;
    }
    .alert-danger .alert-heading {
        color: #dc3545;
        font-size: 1.1rem;
        margin-bottom: 10px;
    }
    .alert-danger hr {
        border-top-color: #f5c6cb;
        margin: 15px 0;
    }
    .alert-danger p {
        margin-bottom: 8px;
        font-size: 0.95rem;
    }
    .alert-danger strong {
        color: #721c24;
    }
</style>
<script>
    // Fix dropdown on mobile
    document.addEventListener('DOMContentLoaded', function() {
        var dropdowns = document.querySelectorAll('.dropdown-toggle');
        dropdowns.forEach(function(dropdown) {
            dropdown.addEventListener('click', function(e) {
                if (window.innerWidth < 992) {
                    e.preventDefault();
                    e.stopPropagation();
                    var dropdownMenu = this.nextElementSibling;
                    dropdownMenu.classList.toggle('show');
                }
            });
        });
    });
</script>
</body>
</html>
