-- Migration for Invoicing System
-- Run this to create all required tables and fields

-- Create new tables
CREATE TABLE invoices (
    id INT AUTO_INCREMENT PRIMARY KEY,
    client_id INT NOT NULL,
    invoice_number VARCHAR(50) UNIQUE NOT NULL,
    issue_date DATE NOT NULL,
    due_date DATE NULL,
    status ENUM('draft', 'issued', 'partially_paid', 'paid', 'void') DEFAULT 'draft',
    currency VARCHAR(3) NOT NULL,
    subtotal DECIMAL(12,2) NOT NULL,
    total DECIMAL(12,2) NOT NULL,
    notes TEXT NULL,
    created_by INT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_client_id (client_id),
    INDEX idx_status (status),
    INDEX idx_issue_date (issue_date)
);

CREATE TABLE invoice_items (
    id INT AUTO_INCREMENT PRIMARY KEY,
    invoice_id INT NOT NULL,
    application_id INT NOT NULL,
    description VARCHAR(255) NOT NULL,
    credit_units INT NOT NULL,
    expiry_date DATE NULL,
    unit_price DECIMAL(12,2) NOT NULL,
    quantity DECIMAL(12,2) DEFAULT 1,
    line_subtotal DECIMAL(12,2) NOT NULL,
    metadata_json JSON NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_invoice_id (invoice_id),
    INDEX idx_application_id (application_id),
    INDEX idx_expiry_date (expiry_date)
);

CREATE TABLE payments (
    id INT AUTO_INCREMENT PRIMARY KEY,
    client_id INT NOT NULL,
    payment_date DATE NOT NULL,
    amount DECIMAL(12,2) NOT NULL,
    currency VARCHAR(3) NOT NULL,
    method ENUM('cash', 'bank', 'card', 'transfer', 'other') NOT NULL,
    reference VARCHAR(100) NULL,
    notes TEXT NULL,
    created_by INT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_client_id (client_id),
    INDEX idx_payment_date (payment_date)
);

CREATE TABLE payment_allocations (
    id INT AUTO_INCREMENT PRIMARY KEY,
    payment_id INT NOT NULL,
    invoice_id INT NOT NULL,
    amount DECIMAL(12,2) NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_payment_id (payment_id),
    INDEX idx_invoice_id (invoice_id)
);

CREATE TABLE credits_ledger (
    id INT AUTO_INCREMENT PRIMARY KEY,
    client_id INT NOT NULL,
    application_id INT NOT NULL,
    invoice_id INT NOT NULL,
    invoice_item_id INT NOT NULL,
    credit_units INT NOT NULL,
    currency VARCHAR(3) NOT NULL,
    expiry_date DATE NULL,
    status ENUM('active', 'expired', 'reversed') DEFAULT 'active',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_client_app (client_id, application_id),
    INDEX idx_status_expiry (status, expiry_date),
    INDEX idx_invoice_id (invoice_id)
);

-- Add new credit_balance field
ALTER TABLE tbl_clients_applications ADD COLUMN credit_balance DECIMAL(12,2) DEFAULT 0;

-- Populate credit_balance from existing stop_at
UPDATE tbl_clients_applications 
SET credit_balance = COALESCE(stop_at, 0) 
WHERE credit_balance = 0;
