<?php
ob_start();
session_start();

include_once("../includes/config.php");
require_once("../includes/DataBaseObjects.php");
require_once("post_variables.php");

// ======================== ENCODING USERNAME AND PASS ==============================
function encode($string, $key) {
    $key = sha1($key);
    $strLen = strlen($string);
    $keyLen = strlen($key);
    $hash = '';
    $j = 0;
    
    for ($i = 0; $i < $strLen; $i++) {
        $ordStr = ord(substr($string, $i, 1));
        if ($j == $keyLen) {
            $j = 0;
        }
        $ordKey = ord(substr($key, $j, 1));
        $j++;
        $hash .= strrev(base_convert(dechex($ordStr + $ordKey), 16, 36));
    }
    
    return $hash;
}
//=================================================================================

if ($_GET['page'] == "add_hajj_user") {
    if (!empty($hajj_user_name)) {
        $query = "INSERT INTO `tbl_eghajj_users` (`hajj_user`) VALUES (?)";
        $stmt = $db1->prepare($query);
        if ($stmt->execute([$hajj_user_name])) {
            header('Location: ../admin/?page=add_hajj_user&status=added_successfully');
        } else {
            echo "Error: " . $stmt->errorInfo()[2];
        }
    }
}

// ======================== ADD CLIENT QUERY ======================================
if ($_GET['page'] == "add_Client") {
    $Start_Balance = empty($Start_Balance) ? null : (int)$Start_Balance;
    $safa_ea_id = empty($safa_ea_id) ? null : (int)$safa_ea_id;

    $sql = "INSERT INTO tbl_clients 
            (id, CompanyName, PersonIncharge, Country, City, Telephone, Email, MSN, Purchase_Date, Renew_Date, Start_Balance, Message, safa_ea_id, max_license)
            VALUES
            (NULL, :CompanyName, :PersonIncharge, :Country, :City, :Telephone, :Email, :MSN, :PurchaseDate, :RenewDate, :StartBalance, :Message, :safaEaId, 2)";
    $stmt = $db1->prepare($sql);
    
    $stmt->execute([
        ':CompanyName' => $Company_name,
        ':PersonIncharge' => $Person_Incharge,
        ':Country' => $Country,
        ':City' => $City,
        ':Telephone' => $Telephone,
        ':Email' => $Email,
        ':MSN' => $MSN,
        ':PurchaseDate' => $Purchase_Date,
        ':RenewDate' => $Renew_Date,
        ':StartBalance' => $Start_Balance,
        ':Message' => $Message,
        ':safaEaId' => $safa_ea_id
    ]);

    $last_id = $db1->lastInsertId();

    // Inserting data into tbl_clients_applications
    $appData = [
        [1, $Available_Safa, $Block_Safa],
        [2, $Available_Enjaz, $Block_Enjaz],
        [3, $Available_Scan, $Block_Scan],
        [4, $Available_Offline, $Block_Offline],
        [6, $Available_Offline, $Block_Offline]
    ];

    $sql = "INSERT INTO tbl_clients_applications 
            (id, App_Id, Client_id, availability, Blocked, Time_stamp)
            VALUES (NULL, :AppId, :ClientId, :Availability, :Blocked, NOW())";
    $stmt = $db1->prepare($sql);

    foreach ($appData as $data) {
        $stmt->execute([
            ':AppId' => $data[0],
            ':ClientId' => $last_id,
            ':Availability' => $data[1],
            ':Blocked' => $data[2]
        ]);
    }

    header("Location: ../admin/?page=Edit_Client&id=$last_id");
}

// ======================== EDIT CLIENT QUERY ======================================
if ($_GET['page'] == "edit_Client") {
    $id = $_GET['id'];
    
    // Ensure that $safa_ea_id is either an integer or null
    if (empty($safa_ea_id)) {
        $safa_ea_id = null;
    } else {
        $safa_ea_id = (int) $safa_ea_id;
    }
    // Ensure that $Start_Balance is either an integer or defaults to 0
    if ($Start_Balance === null) {
        $Start_Balance = 0; // Default to 0 if NULL
    } else {
        $Start_Balance = (int) $Start_Balance; // Cast to integer
    }
    
    // First, update the client details (as before)
    $query = "UPDATE `tbl_clients` SET  
        `CompanyName` = :CompanyName,
        `PersonIncharge` = :PersonIncharge,
        `Country` = :Country,
        `City` = :City,
        `Telephone` = :Telephone,
        `Email` = :Email,
        `MSN` = :MSN,
        `Purchase_Date` = :Purchase_Date,
        `Renew_Date` = :Renew_Date,
        `Barcode_Enabled` = :barcode,
        `free_license` = :free_license,
        `Start_Balance` = :Start_Balance,
        `max_license` = :max_license,
        `Message` = :Message,
        `safa_ea_id` = :safa_ea_id
        WHERE `id` = :id";

    $stmt = $db1->prepare($query);
    $stmt->bindValue(':CompanyName', $Company_name);
    $stmt->bindValue(':PersonIncharge', $Person_Incharge);
    $stmt->bindValue(':Country', $Country);
    $stmt->bindValue(':City', $City);
    $stmt->bindValue(':Telephone', $Telephone);
    $stmt->bindValue(':Email', $Email);
    $stmt->bindValue(':MSN', $MSN);
    $stmt->bindValue(':Purchase_Date', $Purchase_Date);
    $stmt->bindValue(':Renew_Date', $Renew_Date);
    $stmt->bindValue(':barcode', $barcode);
    $stmt->bindValue(':free_license', $free_license);
    $stmt->bindValue(':Start_Balance', $Start_Balance);
    $stmt->bindValue(':max_license', $max_license);
    $stmt->bindValue(':Message', $Message);
    $stmt->bindValue(':safa_ea_id', $safa_ea_id);
    $stmt->bindValue(':id', $id);

    if ($stmt->execute()) {
        // Client update successful
    }

    // Fetch all available applications from the tbl_applications table
    $query = "SELECT id, Application_Name FROM tbl_applications WHERE visible = 1";
    $stmt = $db1->prepare($query);
    $stmt->execute();
    $applications = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Loop through the applications to dynamically update based on the input fields
    foreach ($applications as $app) {
        $appName = strtoupper($app['Application_Name']);
        
        // Create dynamic variable names for each application
        $availableVar = "Available_{$appName}";
        $blockVar = "Block_{$appName}";
        $limitVar = "{$appName}_Limit";
        
        // Get the values from the input (assuming they are in POST request)
        $available = isset($_POST[$availableVar]) ? $_POST[$availableVar] : 0;
        $block = isset($_POST[$blockVar]) ? $_POST[$blockVar] : 0;
        $limit = isset($_POST[$limitVar]) && $_POST[$limitVar] !== '' ? (int)$_POST[$limitVar] : 0;


        // Update the tbl_clients_applications for this application
        $query = "UPDATE tbl_clients_applications 
                  SET availability = :available, Blocked = :blocked, Stop_At = :limit
                  WHERE App_Id = :app_id AND Client_id = :client_id";
        $stmt = $db1->prepare($query);
        $stmt->bindValue(':available', $available);
        $stmt->bindValue(':blocked', $block);
        $stmt->bindValue(':limit', $limit);
        $stmt->bindValue(':app_id', $app['id']);
        $stmt->bindValue(':client_id', $id);
        
        if ($stmt->execute()) {
            // Application update successful
        }
    }

    // Redirect after completion
    header('Location: ../admin/?page=Edit_Client&id=' . $id);
}

// Other blocks for `add_user`, `Edit_Dongle`, etc., should follow the same approach: using prepared statements and proper error handling.
// ======================== ADD USER ======================================
if ($_GET['page'] == "add_user") {
    $username = $_POST['username'];
    $password = $_POST['password'];
    $email = $_POST['email'];

    // Encode password using the encode function
    $encodedPassword = encode($password, "secret_key");

    $query = "INSERT INTO `tbl_users` (username, password, email, created_at) 
              VALUES (:username, :password, :email, NOW())";
    $stmt = $db1->prepare($query);
    if ($stmt->execute([
        ':username' => $username,
        ':password' => $encodedPassword,
        ':email' => $email
    ])) {
        header("Location: ../admin/?page=add_user&status=added_successfully");
    } else {
        echo "Error: " . $stmt->errorInfo()[2];
    }
}

// ======================== EDIT DONGLE QUERY ==============================
if ($_GET['page'] == "Edit_Dongle") {
    $id = $_GET['id'];
	$stop_at = !empty($_POST['Stop_At']) ? intval($_POST['Stop_At']) : null;

    $query = "UPDATE `tbl_dongles` SET 
              `Barcode` = :barcode, 
              `Activated` = :activated, 
              `Date_Activated` = :date_activated,
              `License_ID` = :license_id,
              `Stop_At` = :stop_at
              WHERE `id` = :id";

    $stmt = $db1->prepare($query);
    $stmt->execute([
        ':barcode' => $Barcode,
        ':activated' => $Activated,
        ':date_activated' => $Date_Activated,
        ':license_id' => $License_ID,
        ':stop_at' => $stop_at,
        ':id' => $id
    ]);

    header("Location: ../admin/?page=Edit_Dongle&id=$id");
}

// ======================== DELETE CLIENT ==================================
if ($_GET['page'] == "delete_Client") {
    $id = $_GET['id'];

    $query = "DELETE FROM `tbl_clients` WHERE `id` = :id";
    $stmt = $db1->prepare($query);
    if ($stmt->execute([':id' => $id])) {
        header("Location: ../admin/?page=manage_clients&status=deleted_successfully");
    } else {
        echo "Error: " . $stmt->errorInfo()[2];
    }
}

// ======================== LIST CLIENTS ===================================
if ($_GET['page'] == "list_Clients") {
    $query = "SELECT * FROM `tbl_clients`";
    $stmt = $db1->prepare($query);
    $stmt->execute();
    $clients = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($clients as $client) {
        echo "<tr>
                <td>{$client['CompanyName']}</td>
                <td>{$client['PersonIncharge']}</td>
                <td>{$client['Country']}</td>
                <td>{$client['City']}</td>
                <td>{$client['Telephone']}</td>
                <td>{$client['Email']}</td>
                <td><a href='?page=Edit_Client&id={$client['id']}'>Edit</a></td>
                <td><a href='?page=delete_Client&id={$client['id']}' onclick='return confirm(\"Are you sure?\")'>Delete</a></td>
            </tr>";
    }
}

// ======================== DELETE DONGLE ==================================
if ($_GET['page'] == "delete_Dongle") {
    $id = $_GET['id'];

    $query = "DELETE FROM `tbl_dongles` WHERE `id` = :id";
    $stmt = $db1->prepare($query);
    if ($stmt->execute([':id' => $id])) {
        header("Location: ../admin/?page=manage_dongles&status=deleted_successfully");
    } else {
        echo "Error: " . $stmt->errorInfo()[2];
    }
}

// ======================== LIST DONGLES ===================================
if ($_GET['page'] == "list_Dongles") {
    $query = "SELECT * FROM `tbl_dongles`";
    $stmt = $db1->prepare($query);
    $stmt->execute();
    $dongles = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($dongles as $dongle) {
        echo "<tr>
                <td>{$dongle['Barcode']}</td>
                <td>{$dongle['Activated']}</td>
                <td>{$dongle['Date_Activated']}</td>
                <td><a href='?page=Edit_Dongle&id={$dongle['id']}'>Edit</a></td>
                <td><a href='?page=delete_Dongle&id={$dongle['id']}' onclick='return confirm(\"Are you sure?\")'>Delete</a></td>
            </tr>";
    }
}

// ======================== USER LOGIN =====================================
if ($_POST['action'] == "login") {
    $username = $_POST['username'];
    $password = $_POST['password'];
    $encodedPassword = encode($password, "secret_key");

    $query = "SELECT * FROM `tbl_users` WHERE `username` = :username AND `password` = :password";
    $stmt = $db1->prepare($query);
    $stmt->execute([
        ':username' => $username,
        ':password' => $encodedPassword
    ]);

    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($user) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['username'] = $user['username'];
        header("Location: ../admin/dashboard.php");
    } else {
        echo "Invalid username or password!";
    }
}

// ======================== USER LOGOUT ====================================
if ($_GET['action'] == "logout") {
    session_destroy();
    header("Location: ../admin/login.php");
}

// ======================== DASHBOARD STATS ==================================
if ($_GET['page'] == "dashboard") {
    // Example dashboard stats query
    $query = "SELECT COUNT(*) as total_clients FROM tbl_clients";
    $stmt = $db1->prepare($query);
    $stmt->execute();
    $total_clients = $stmt->fetch(PDO::FETCH_ASSOC)['total_clients'];

    echo "<h3>Total Clients: $total_clients</h3>";
}
?>
