<?php
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit();
}
?>
<div class="container py-4">
    <h3>Currency Rates</h3>
    <p class="text-muted">Units per USD (USD=1, SAR=3.75)</p>
    <div class="table-responsive">
        <table class="table table-bordered align-middle" id="ratesTable">
            <thead>
                <tr>
                    <th>Currency</th>
                    <th>Units per USD</th>
                </tr>
            </thead>
            <tbody></tbody>
        </table>
    </div>
    <button class="btn btn-primary" id="saveRates">Save</button>
</div>

<script>
document.addEventListener('DOMContentLoaded', async () => {
    const tbody = document.querySelector('#ratesTable tbody');

    async function loadRates() {
        const res = await fetch('api/currency_rates.php');
        const data = await res.json();
        tbody.innerHTML = '';
        const currencies = ['USD','SAR','EGP','EUR','GBP'];
        const byCode = {};
        (data.rates || []).forEach(r => byCode[r.currency_code] = r);
        currencies.forEach(code => {
            const row = byCode[code] || { currency_code: code, units_per_usd: code === 'USD' ? 1 : '' };
            const tr = document.createElement('tr');
            tr.innerHTML = `
                <td>${row.currency_code}</td>
                <td><input type="number" step="0.0001" min="0" class="form-control form-control-sm" value="${row.units_per_usd}"></td>
            `;
            tbody.appendChild(tr);
        });
    }

    document.getElementById('saveRates').addEventListener('click', async () => {
        const payload = [];
        tbody.querySelectorAll('tr').forEach(tr => {
            const code = tr.children[0].textContent.trim();
            const units = parseFloat(tr.querySelector('input').value);
            if (!isNaN(units) && units > 0) {
                payload.push({ currency_code: code, units_per_usd: units });
            }
        });
        await fetch('api/currency_rates.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify(payload)
        });
        await loadRates();
        alert('Saved');
    });

    loadRates();
});
</script>


